qui {

noi {
	/*************************************************/
	/***** Step 2.6.2. Full-sample p-values		    **/
	/*************************************************/
}

noi {
	/*************************************************/
	/***** Step 2.6.2.1. NIC-specific p-values	    **/
	/*************************************************/
}
	* STEP 1: compute p-values for NIC-specific independence dividend estimates
	local count = 0
	cd ..
	
	noi di ""
	noi di "Computing p-values for NIC (/$totalNICs)", _continue
	foreach cntry of global NICs {
		
		* Load raw estimates
		cd ".\3. Intermediary results\3.4. Intermediaries" 	
		cap use PIDD1_`cntry', clear
		cd ..
		cd ..
		
		if _rc == 0 {
			
			* Track progress
			local count = `count' + 1
			noi di `count', _continue
			
			* Generate placebo-independence years
			gen pindependence_years = .
			foreach year of numlist $startyear / 2016 {
				sum independence_years if year == `year' & cntrycode == `cntry'
				cap replace pindependence_years = `r(mean)' if year == `year'
				}
					
			* Generate placebo country codes
			gen pcntrycode = cntrycode if cntrycode == `cntry'
			replace pcntrycode = 1000*`cntry'+cntrycode if cntrycode != `cntry'
			
			* Generate trend-demeaned (placebo) independence dividends
			gen PTDIDD = .
			levelsof pcntrycode if lgap_`cntry' != ., local(countries)	
			foreach CNTRY in `countries' {
				sum lgap_`cntry' if pindependence_years >= -10 & pindependence_years <= -1 & pcntrycode == `CNTRY'
				replace PTDIDD = lgap_`cntry'-`r(mean)' if pcntrycode == `CNTRY'
				}

			* Compute full-path p-values
			gen pvalue = .
			sum pindependence_years
			foreach year of numlist `r(min)'/`r(max)' {
				local pointestimate
				sum PTDIDD if pindependence_years == `year' & pcntrycode == `cntry'
				cap local pointestimate = `r(mean)'
				sum PTDIDD if pindependence_years == `year' & pcntrycode > 400
				cap replace pvalue = 2*ttail(`r(N)'-1,abs( (`pointestimate'-`r(mean)')/`r(sd)')) if pcntrycode == `cntry' & pindependence_years == `year' 
				}
				
			* Save results 
			cd ".\3. Intermediary results\3.4. Intermediaries"
			gen TDIDD = PTDIDD if cntrycode == `cntry'
			keep cntry cntrycode year independence_years TDIDD pvalue
			keep if cntrycode == `cntry'
			keep if TDIDD != .
			save IDD1_p_`cntry', replace
			cd ..
			cd ..
			}
		}
		
	* STEP 2: Gather all results
	clear all
	cd ".\3. Intermediary results\3.4. Intermediaries"
	foreach cntry of global NICs {
		cap append using IDD1_p_`cntry'
		}
	cd ..
	save IDD1_p, replace
	cd ..
	
	* STEP 3: Plot results
		
		* NIC-trajectories
		preserve
		expand 2, gen(n)
		replace year = year-.5 if n == 1
		replace independence_years = independence_years-.5 if n == 1
		drop n
		sort cntrycode year
		gen TDIDD_1 = TDIDD if pvalue > .1
		gen TDIDD_2 = TDIDD if pvalue <= .1 & pvalue > .05
		gen TDIDD_3 = TDIDD if pvalue <= .05 & pvalue > .01
		gen TDIDD_4 = TDIDD if pvalue <= .01

		foreach i in $NICs {
			local discrepancy_1  "`discrepancy_1' (line TDIDD_1 independence_years if cntrycode == `i', lc(gs15) cmiss(n))   || "
			local discrepancy_2  "`discrepancy_2' (line TDIDD_2 independence_years if cntrycode == `i' , lc(gs12) cmiss(n))  || "
			local discrepancy_3  "`discrepancy_3' (line TDIDD_3 independence_years if cntrycode == `i', lc(gs8) cmiss(n))  || "
			local discrepancy_4  "`discrepancy_4' (line TDIDD_4 independence_years if cntrycode == `i', lc(gs0) cmiss(n))  || "
			}
			
		sort cntrycode independence_years
		twoway 	`discrepancy_1' || ///
				`discrepancy_2' || ///
				`discrepancy_3' || ///
				`discrepancy_4' || ///
				if independence_years >= -10 & independence_years <= 30, xtitle("Years of independence", size(large)) ytitle("Independence dividend", size(large)) xline(0, lpattern(shortdash) lcolor(gs7) lstyle(foreground)) graphregion(color(white)) bgcolor(white) legend(order(1 "p>.1" 200 "p{&le}.1" 400 "p{&le}.05" 500 "p{&le}.01") rows(1)) xlab(-10(5)30)
		cd ".\5. TeX results"
		graph export figure8_1.pdf, replace
		cd ..
		restore

noi {
	/*************************************************/
	/***** Step 2.6.2.2. Aggregate p-values	    ******/
	/*************************************************/
}

	* STEP 4: compute aggregate p-values (cf. Cavallo 2013)
	
		* Collect data
		noi di ""
		noi di "Data preparation:", _continue
		cd ".\3. Intermediary results\3.4. Intermediaries"
		cap confirm file total_file.dta
		cd ..
		cd ..
		if _rc != 0 {
			foreach cntry of global NICs {
		
				* Load raw estimates
				cd ".\3. Intermediary results\3.4. Intermediaries" 	
				cap use PIDD1_`cntry', clear
				cd ..
				cd ..
				if _rc == 0 {
					
					* Track progress
					noi di ., _continue
					
					* Add population data
					cd "./4. Master data"
					merge 1:1 cntrycode year using master_data, keepusing(popshare)
					keep if _merge == 3
					drop _merge
					cd ..
					
					* Generate placebo-independence years
					gen pindependence_years = .
					foreach year of numlist $startyear / 2016 {
						sum independence_years if year == `year' & cntrycode == `cntry'
						cap replace pindependence_years = `r(mean)' if year == `year'
						}
							
					* generate placebo country codes
					gen pcntrycode = cntrycode if cntrycode == `cntry'
					replace pcntrycode = 1000*`cntry'+cntrycode if cntrycode != `cntry'
					
					keep lgap_`cntry' pindependence_years pcntrycode cntry year rmspe popshare
					rename pindependence_years independence_years
					rename lgap_`cntry' lgap
					rename pcntrycode cntrycode

					* Collect estimated weights for each potential control country
					levelsof cntrycode if lgap != ., local(countries)	
										
					* Compute bias-corrected placebo-gaps
					gen bc_lgap = .
					foreach cntry_2 in `countries' {
						sum lgap if independence_years >= -10 & independence_years <= -1 & cntrycode == `cntry_2'
						replace bc_lgap = lgap-`r(mean)' if cntrycode == `cntry_2'
						}
						
					* Generate country-codes & names
					egen placebocntrycode = group(cntrycode) if cntrycode != `cntry'

					replace placebocntrycode = `cntry'*1000+placebocntrycode
					replace placebocntrycode = `cntry' if cntrycode == `cntry'
					drop cntrycode lgap
					drop if independence_years == .
					rename placebocntrycode cntrycode
					
					preserve
					keep if cntrycode == `cntry'
					local cname = cntry[1]
					restore
					
					egen helpme = group(cntrycode) if cntrycode != `cntry'
					tostring helpme, replace
					replace cntry = "`cname': placebo country " + helpme + " [" + cntry +"]" if cntrycode != `cntry'
					drop helpme
					
					* Save
					order cntrycode cntry year independence_years bc_lgap* rmspe
					sort independence_years
					cd ".\3. Intermediary results\3.4. Intermediaries" 	
					save results_`cntry', replace
					cd ..
					cd ..
				}
			}
		
			clear all
			cd ".\3. Intermediary results\3.4. Intermediaries" 	
			foreach cntry of global NICs {
				cap append using results_`cntry'
				cap erase results_`cntry'.dta
				sort cntrycode independence_years
				save total_file, replace
				}
			cd ..
			cd ..
			}
		
		* Bootstrap pvalues
		noi di ""
		noi di ""
		noi di "Estimating bootstrapped p-values for aggregate independence dividend estimates, iteration (/${firststepreps}):", _continue
		noi di ""
		
			* Get data
			cd ".\3. Intermediary results\3.4. Intermediaries"
			use total_file, clear
			cd ..
			cd ..

			* Compute aggregate independence dividend
			preserve
			collapse (mean) bc_lgap [w=popshare] if cntrycode < 400, by(independence_years)
			gen iteration = 0	
			tempfile bs
			save `bs', emptyok
			restore
			
			* Bootstrap placebo-estimates
			cd ".\3. Intermediary results\3.4. Intermediaries"
			foreach iteration of numlist 1/$firststepreps {
				noi di `iteration', _continue
				preserve
				gen cntrycode_NIC = cntrycode if cntrycode < 400
				replace cntrycode_NIC = round(cntrycode/1000) if cntrycode > 400
				bsample 1 if cntrycode > 400, cluster(cntrycode) strata(cntrycode_NIC)
				collapse (mean) bc_lgap [w=popshare], by(independence_years)
				gen iteration = `iteration'
				append using `bs', force
				save `bs', replace
				restore
				}
			
			* Get actual and bootstrapped placebo results
			use `bs'
			sort iteration independence_years
			
			* Generate necessary variables
			gen pvalue = .
			gen pe_ll_n = .
			gen pe_ul_n = .
			gen pe_ll_e = .
			gen pe_ul_e = .
			gen PTTDIDD = .
			gen PTTDDIDD_ll = .
			gen PTTDDIDD_ul = .
			
			* Export inferential results
			cd ..
			cd ..
			local count = 0
			foreach year of numlist -10/30 {
				
				local count = `count' + 1
				
				* Empirical CI's
				_pctile bc_lgap if independence_years == `year' & iteration != 0, percentile(2.5 97.5)
				local p25 = r(r1)
				local p975 = r(r2)
				
				sum bc_lgap if independence_years == `year' & iteration != 0
				local pe = r(mean)
				

				replace pe_ll_e = `p25' if independence_years == `year' 
				replace pe_ul_e = `p975' if independence_years == `year' 
				
				* Normal CI's
				sum bc_lgap if independence_years == `year' & iteration != 0
				local pe = `r(mean)'
				local p25 = `pe'+invttail((`r(N)'-1),.975)*`r(sd)'
				local p975 = `pe'+invttail((`r(N)'-1),.025)*`r(sd)'
				
				sum bc_lgap if independence_years == `year' & iteration != 0
				if `r(N)' != 0 {
					replace pe_ll_n = `pe'+invttail((`r(N)'-1),.975)*`r(sd)' if independence_years == `year' 
					replace pe_ul_n = `pe'+invttail((`r(N)'-1),.025)*`r(sd)' if independence_years == `year' 
					}
					
				* Both
				_pctile bc_lgap if independence_years == `year' & iteration != 0, percentile(2.5 97.5)
				local p25_e = r(r1)
				local p975_e = r(r2)
				sum bc_lgap if independence_years == `year' & iteration != 0
				local pe = `r(mean)'
				local p25_n = `pe'+invttail((`r(N)'-1),.975)*`r(sd)'
				local p975_n = `pe'+invttail((`r(N)'-1),.025)*`r(sd)'
				sum bc_lgap if independence_years == `year' & iteration == 0
				histogram bc_lgap if independence_years == `year' & iteration != 0, fraction normal blcolor(gs0) bfcolor(gs0*.25) addplot(pci 0 `r(mean)' .15 `r(mean)', lc(red) lw(thick)) bgcolor(white) graphregion(color(white)) legend(off) xline(`p25_e' `p975_e', lc(gs0) lp(dash)) xline(`p25_n' `p975_n', lc(gs6) ) yla(0 "0%" .1 "10%" .2 "20%", ang(h)) ytitle("Fraction of placebo estimates", size(large)) xtitle("Placebo independence dividend estimate", size(large))
				cd ".\5. TeX results"
				graph export figureA5_`count'.pdf, replace
				cd ..
				
				* Compute aggregate p-values
				sum bc_lgap if independence_years == `year' & iteration == 0
				cap local pointestimate = `r(mean)'
				sum bc_lgap if independence_years == `year' & iteration != 0
				cap replace pvalue = 2*ttail(`r(N)'-1, abs((`pointestimate'-`r(mean)')/`r(sd)')  ) if independence_years == `year' & iteration == 0
				cap replace PTTDIDD = bc_lgap-`r(mean)' if independence_years == `year' & iteration == 0
				cap replace PTTDDIDD_ll = PTTDIDD+invttail(`r(N)'-1,.975)*`r(sd)' if independence_years == `year' & iteration == 0
				cap replace PTTDDIDD_ul = PTTDIDD+invttail(`r(N)'-1,.025)*`r(sd)' if independence_years == `year' & iteration == 0
				}
								
				* Export inferential implications
				preserve
				keep if iteration == 0
				twoway 	(connected bc_lgap independence_years if pvalue <= .01, lcolor(none) mcolor(gs0) msize(large)) ///
						(connected bc_lgap independence_years if pvalue > .01 & pvalue <= .05, lcolor(none) mfcolor(gs8) mlcolor(gs0) msize(large)) ///
						(connected bc_lgap independence_years if pvalue > .05 & pvalue <= .1, lcolor(none) mfcolor(gs12) mlcolor(gs0) msize(large)) ///
						(connected bc_lgap independence_years if pvalue > .1, lcolor(none) mfcolor(none) mlcolor(gs0) msize(large)) ///
						(line bc_lgap independence_years, lcolor(gs0)) ///
						(scatter pvalue independence_years, mcolor(gs0) msize(small) yaxis(2)) ///
						if independence_years >= -10 & independence_years <= 30, ytitle("Average independence dividend") yla(, axis(1) ang(h)) yla(, axis(2) ang(h)) ytitle("P-value", axis(2)) xtitle(Year, size(large)) xline(0, lcolor(red) lpattern(shortdash)) yscale(titlegap(*-30)) graphregion(color(white)) bgcolor(white) legend(order(1 "Independence dividend (p<.01)" 2 "Independence dividend (p<.05)" 3 "Independence dividend (p<.1)" 4 "Independence dividend (p>.1)" 6 "P-value of estimate") rows(3) size(small) symxsize(small)) 
				cd ".\5. TeX results"
				graph export figure8_2.pdf, replace
				cd ..
				restore
				
					* Plot aggregate (raw) independence dividend estimates + 95% CI
					preserve
					keep if iteration == 0
					sort iteration independence_years
					
					gen refline = 0
					twoway 	(rarea PTTDDIDD_ll PTTDDIDD_ul independence_years, astyle(ci2) acolor(gs14)) || ///
							(line refline independence_years, lcolor(red)) || ///
							(connected PTTDIDD independence_years, lcolor(gs0) mlcolor(gs0) mfcolor(gs0) msymbol(O)) || ///
							if independence_years >= -10 & independence_years <= 30 || ///
							, legend(off) ytitle("Independence dividend", size(large)) xtitle("Years of independence", size(large)) xline(0, lcolor(red) lpattern(dot) lstyle(foreground)) yline(0, lstyle(foreground) lcolor(gs0) lpattern(dot)) graphregion(color(white)) bgcolor(white) ///
							note("with 95% confidence interval")
					cd ".\5. TeX results"
					graph export figure10.pdf, replace
					cd ..
					
					* Save results
					cd ".\3. Intermediary results"
					save baseline_results, replace
					cd ..

noi di ""
noi {
	/*************************************************************/
	/***** Step 2.6.2.3. Actual vs placebo trajectories	    ******/
	/*************************************************************/
}
	* Plot actual versus placebo distributions for each NIC 
		
			* Get data
			cd ".\3. Intermediary results\3.4. Intermediaries"
			use total_file, clear
			cd ..
			cd ..
			replace cntry = "Lesotho" if cntry == "Basutoland (Lesotho)"

			* Plot results
			levelsof cntrycode if cntrycode < 500, local(NICs)
			
			local case = 0
			foreach NIC in `NICs' {
				
				* Keep track of cases
				local case = `case'+1
				
				* Plot results for this particular NIC
				clear all
				cd ".\3. Intermediary results\3.4. Intermediaries"
				use total_file, clear
				cd ..
				cd ..
				replace cntry = "Lesotho" if cntry == "Basutoland (Lesotho)"
				replace cntry = "Serbia" if cntry == "ZzSerbia"
				replace cntry = "Rwanda" if cntry == "Ruanda"

				local lower_cutoff = `NIC'*1000															// Identify placebo countries
				local upper_cutoff = (`NIC'+1)*1000 - 1
				keep if cntrycode == `NIC' | cntrycode >= `lower_cutoff' & cntrycode <= `upper_cutoff'	// Keep NIC + placebo countries
				sort cntrycode
				local cntryname = cntry[1]																// Identify NIC
				
				levelsof cntrycode if cntrycode >= `lower_cutoff' & cntrycode <= `upper_cutoff', local(placeboNICs)
				local discrepancy_`NIC'
				foreach i in `placeboNICs' {
					local discrepancy_`NIC'  "`discrepancy_`NIC'' (line bc_lgap independence_years if cntrycode == `i', lc(gs12))   || "
					}
					
				twoway `discrepancy_`NIC'' || ///
						(line bc_lgap independence_years if cntrycode == `NIC', lc(gs0)) ///
						if independence_years >= -10 & independence_years <= 30 & bc_lgap != .,  legend(off) xline(0, lcolor(red)) ytitle("Gap in log per capita GDP", size(large)) xtitle("Years of independence", size(large)) title(`cntryname', size(vlarge)) graphregion(color(white)) bgcolor(white)
				cd "./5. TeX results"
				graph export figureA8_`case'.pdf, replace
				cd ..
				}
			
	* Reroute to directory containing dofiles
	cd ".\1. Dofiles"
	}
